﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SSToolBox.Windows.Forms
{
	public delegate void ReleaseErrorDelegate(object sender,EventReleaseErrorArgs e);

	public enum EunmException
	{
		InputInjectionSql=0,
		InputNoCurrency,
		InputNoNumeric,
		InputNoEmail,
		InputStringError
	}

	public class EventReleaseErrorArgs
	{
		private EunmException _idMessage;

		public string Message { get; private set; }
		
		public EunmException EnumMessage
		{
			get { return (_idMessage); }
			set { Check(value); _idMessage = value; }
		}

		private void Check(EunmException id)
		{
			switch (id)
			{
				case EunmException.InputInjectionSql:
				{
					Message = "ورودی خطای هک دارد";
					break;
				}

				default:
				{
					Message = "ورودی خطا دارد";
					break;
				}
			}
		}
	}

	internal class PublicClass
	{
		private static string _strInjectin = "!,@,#,%,^,&,*,(,),+,=";

		public static bool CheckInjectionSql(string strValue)
		{
			string[] strInjectin = _strInjectin.Split(',');

			for (int i = 0; i < strInjectin.Length; i++)
			{
				if (strValue.IndexOf(strInjectin[i]) != -1)
				{
					return true;
				}
			}

			return false;
		}

		public static bool CheckInjectionSql(char chValue)
		{
			string[] strInjectin = _strInjectin.Split(',');

			for (int i = 0; i < strInjectin.Length; i++)
			{
				if (chValue.ToString() == strInjectin[i])
				{
					return true;
				}
			}

			return false;
		}
	}
}
